#COMMENTS-START
Portable App Shortcut was written by maroesjk (nickname of Ren Dijkmans)
Please see the 'readme.pdf' file for general and/or copyright information

Package version:				0972 beta
Last changes in this script:	6 January 2009
#COMMENTS-END

#NoTrayIcon

$ScriptProcesses = ProcessList(@ScriptName)															;Get ProcessList for the script
If $ScriptProcesses[0][0] > 1 Then _																;If more than one instance
	Exit(MsgBox(16, 'Error', 'Only one instance of "' & @ScriptName & '" allowed.'))				;Display error and exit the script

;BEGIN SET OPTIONS AND DEFINING VARIABLES 
EnvSet			('system32', @SystemDir)

Global 	$PADrive		= StringLeft(@ScriptDir, 2), $ScriptName = StringLeft(@ScriptName, StringLen(@ScriptName) - 4), $Temp = @TempDir & '\Data.' & $ScriptName & '\', $IniFile = $Temp & $ScriptName & '.ini', $RegFile	= $Temp & $ScriptName & '.reg', $LstFile = $Temp & $ScriptName & '.lst', _
		$EnvArray[5]	= [4, 'system32', 'allusersprofile', 'userprofile', 'commonprogramfiles'], $EnvGetAr[5]	= [4, EnvGet($EnvArray[1]), EnvGet($EnvArray[2]), EnvGet($EnvArray[3]), EnvGet($EnvArray[4])], _
		$RegTypes[11]	= ['REG_NONE', 'REG_SZ', 'REG_EXPAND_SZ', 'REG_BINARY', 'REG_DWORD', 'REG_DWORD_BIG_ENDIAN', 'REG_LINK', 'REG_MULTI_SZ', 'REG_RESOURCE_LIST', 'REG_FULL_RESOURCE_DESCRIPTOR', 'REG_RESOURCE_REQUIREMENTS_LIST']
		DirCopy			  (@ScriptDir & '\Data', StringLeft($Temp, StringLen($Temp) - 1))			;Copy the Data folder
		$AppDrive		= IniRead($IniFile, 'application', 'drive', StringLeft(@ScriptDir, 1))		;Read/build the drive where the application is situated
		If $AppDrive	= 'PA' Then $AppDrive = StringLeft($PADrive, 1)								;If that drive is 'PA' then the drive is the PA-drive
		$AppFolder 		= $AppDrive & ':\' & IniRead($IniFile, 'application', 'folder', '') & '\'	;Read/build the folder where the application is situated					
;END SET OPTIONS AND DEFINING VARIABLES 

;MAIN PROGRAM
If Not IsAdmin() And FileExists(@ScriptDir & '\Data\' & $EnvArray[1]) Then _						;Display information if Admin rights might be required
	MsgBox(48, $ScriptName, @UserName & ' is not an Administrator on this system.' & @CRLF & $ScriptName & ' might need administrative rights in order to function correctly.', 5)
If FileExists	($RegFile)	Then RegSet()
If FileExists	($LstFile)	Then FileSet()
ShellExecuteWait($AppFolder & IniRead($IniFile, 'application', 'file', ''), '', $AppFolder)
ProcessWaitClose(IniRead($IniFile, 'application', 'filewait', ''))
If FileExists	($RegFile)	Then RegRestore()
If FileExists	($LstFile)	Then FileRestore()
DirCopy			($Temp, @ScriptDir & '\Data\', 1)
DirRemove		($Temp, 1)
;END MAIN PROGRAM

Func RegSet()								;SETS THE PA-DRIVE'S REGISTRY-INFORMATION, MAKING A BACKUP OF THE HOSTS REGISTRY-INFORMATION
	$FileLines	= FileCountLines($RegFile)															;Count the number of lines in $RegFile
	For $LineNumber		= 1 to $FileLines															;Examine each line in the $RegFile
		$RegInfo		= StringSplit(FileReadLine($RegFile, $LineNumber), ', ', 1)					;Split the line using ', '
		$HostValue		= RegRead($RegInfo[1], $RegInfo[2])											;HostValue is the original value of the hosts registry
		$HostType		= $RegTypes[@extended]														;HostType is the original type of the value in the hosts registry. This will be 'REG_NONE' if the value doesn't exist
		$HostValue		= 				StringReplace($HostValue,	@lf, '@lf')						;Replace the linefeed character
		$RegInfo[4]		= StringReplace(StringReplace($RegInfo[4], '@lf', @lf), 'PA:', $PADrive)	;Replace the linefeed character and PA-drive
		FileWriteLine($RegFile & '.bup', $RegInfo[1] & ', ' & $RegInfo[2] & ', ' & $HostType & _	;Write the original registry information to a backup-file
			', ' & $HostValue)
		RegWrite($RegInfo[1], $RegInfo[2], $RegInfo[3], $RegInfo[4])								;Set the registry to that of the PortableApp
	Next
EndFunc

Func FileSet()								;SETS THE PA-DRIVE'S FILES, MAKING A BACKUP OF THE HOSTS FILES
	$FileLines	= FileCountLines($LstFile)															;Count the number of lines in $LstFile
	For $LineNumber		= 1 to $FileLines															;Examine each line in thet $LstFile
		$PAFFileName	= FileReadLine($LstFile, $LineNumber)
		For $i			= 1 to $EnvArray[0]
			If StringInStr($PAFFileName, $EnvArray[$i]) Then ExitLoop								;If the folder is the right 'environment variable' folder then exitloop
		Next
		If $i = 1 And Not IsAdmin() Then ContinueLoop												;If the 'environment variable' needs Admin rights that aren't available then continueloop
		$FileName = StringReplace($PAFFileName, $EnvArray[$i], $EnvGetAr[$i], 1)					;Get the environment variable which should be used
		If FileExists($FileName) Then FileCopy($FileName, $Temp & $PAFFileName & '.bup')			;If the file exists on the host, backup it
		FileCopy($Temp & $PAFFileName, $FileName, 9)												;Set the file to that of the PortableApp
	Next
EndFunc

Func RegRestore()							;RESTORES THE HOSTS REGISTRY-INFORMATION, MAKING A BACKUP OF THE PA-DRIVE'S REGISTRY-INFORMATION
	FileDelete($RegFile)
	$FileLines			= FileCountLines($RegFile & '.bup')											;Count the number of lines in the backup-RegFile
	For $LineNumber		= 1 to $FileLines															;Examine each line in the backup-RegFile
		$RegInfo		= StringSplit(FileReadLine($RegFile & '.bup', $LineNumber), ', ', 1)
		$HostValue		= RegRead($RegInfo[1], $RegInfo[2])											;HostValue is the new value of the hosts registry
		$HostType		= $RegTypes[@extended]														;HostType is the new type of the value in the hosts registry.
		$RegInfo[4]		= StringReplace($RegInfo[4], '@lf',	@lf)									;Replace the linefeed character
		$HostValue		= StringReplace($HostValue,   @lf, '@lf')									;Replace the linefeed character
		For	$i			= 1 to $EnvArray[0]															;Find out if HostValue points to an 'environment variable'
			If StringInStr($HostValue, $EnvGetAr[$i]) Then Exitloop									;If so then exitloop
			If $i = $EnvArray[0] Then $HostValue = StringReplace($HostValue, $PADrive, 'PA:')		;Else replace the PA-drive
		Next
		FileWriteLine($RegFile, $RegInfo[1] & ', ' & $RegInfo[2] & ', ' & $HostType & ', ' & _		;Write the new registry information to the $RegFile
			$HostValue)
		If $RegInfo[3]	= 'REG_NONE' Then															;If the original key/value did not exist then
			If RegDelete($RegInfo[1], $RegInfo[2]) Then $RegInfo[1] &= '\'							;Delete the key/value
			Do
				$RegInfo[1] = StringTrimRight($RegInfo[1] , StringLen($RegInfo[1]) _				;Walk through the registry branch
					- StringInStr($RegInfo[1] , '\', 0, -1) + 1)
				If Not (RegEnumVal($RegInfo[1], 1) = RegEnumKey($RegInfo[1], 1)) Then ExitLoop		;If any more (sub)keys or values exist then exitloop
			Until Not RegDelete($RegInfo[1]) = 1													;Otherwise try to delete the registry branch
		Else
			RegWrite($RegInfo[1], $RegInfo[2], $RegInfo[3], $RegInfo[4])							;Restore the original registry key
		EndIf
	Next
	FileDelete($RegFile & '.bup')																	;Delete the backup-RegFile
EndFunc
		
Func FileRestore()							;RESTORES THE HOSTS FILES, MAKING A BACKUP OF THE PA-DRIVE'S FILES
	$FileLines			= FileCountLines($LstFile)													;Count the number of lines in $LstFile
	For $LineNumber		= 1 to $FileLines															;Examine each line in thet $LstFile
		$PAFFileName 	= FileReadLine($LstFile, $LineNumber)
		For $i			= 1 to $EnvArray[0]
			If StringInStr($PAFFileName, $EnvArray[$i]) Then ExitLoop								;If the folder is the right 'environment variable' folder then exitloop
		Next
		If $i = 1 And Not IsAdmin() Then ContinueLoop												;If the 'environment variable' needs Admin rights that aren't available then continueloop
		$FileName = StringReplace($PAFFileName, $EnvArray[$i], $EnvGetAr[$i], 1)					;Get the environment variable which should be used
		FileCopy($FileName, $Temp & $PAFFileName, 9)												;Copy the file to the PortableApp
		If FileExists	($Temp	& $PAFFileName & '.bup') Then										;If a backup exists then
			FileCopy	($Temp	& $PAFFileName & '.bup', $FileName, 9)								;Restore the backup
			FileDelete	($Temp	& $PAFFileName & '.bup') 											;Delete the backup
		Else																						;Else
			FileDelete	($FileName)																	;Delete the File
			Do
				$FileName = StringTrimRight($FileName, StringLen($FileName) _						;Walk through the folder branch
					- StringInStr($FileName, '\', 0, -1) + 1)	
				$DirSize = DirGetSize($FileName, 1)													;Get the size of the folder
				If	   $DirSize[1]	Then ExitLoop													;If any more files exist then exitloop
			Until Not DirRemove($FileName, 1) = 1													;Otherwise try to delete the folder branch
		EndIf
	Next
EndFunc
		
Func FileCountLines($File)					;GET THE NUMBER OF LINES FOR A CERTAIN FILE
	Local $N = FileGetSize($File) - 1
	Return StringLen(StringAddCR(FileRead($File, $N))) - $N + 1
EndFunc